#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=389163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:02:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:02:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:02:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377812, 'Database Backup [database_backup_2025-10-10-00-02-02-v3-3-1.zip]', '2025-10-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377915, 'Database Backup [database_backup_2025-10-13-07-06-03-v3-3-1.zip]', '2025-10-13 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (377999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378336, 'Invoice Status Updated [Invoice Number: INV-193/10/2025, From: Unpaid To: Overdue]', '2025-10-13 21:03:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:03:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:03:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:03:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-13 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-13 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-13 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (378999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-14 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-14 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-14 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379177, 'Database Backup [database_backup_2025-10-15-00-02-02-v3-3-1.zip]', '2025-10-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379757, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 190.213.30.56]', '2025-10-15 18:34:29', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379758, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 190.213.30.56]', '2025-10-15 18:34:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-15 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-15 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-15 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379930, 'Database Backup [database_backup_2025-10-16-00-03-02-v3-3-1.zip]', '2025-10-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (379999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380672, 'Database Backup [database_backup_2025-10-17-00-05-03-v3-3-1.zip]', '2025-10-17 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-17 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-17 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-17 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380775, 'Database Backup [database_backup_2025-10-20-07-09-02-v3-3-1.zip]', '2025-10-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (380999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381196, 'Invoice Status Updated [Invoice Number: INV-195/10/2025, From: Unpaid To: Overdue]', '2025-10-20 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381197, 'Invoice Status Updated [Invoice Number: INV-196/10/2025, From: Unpaid To: Overdue]', '2025-10-20 21:02:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:02:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:02:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:02:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-20 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-20 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-20 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (381629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_lo