#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=278899 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (254999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255198, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-16 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255199, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-16 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255305, 'Database Backup [database_backup_2025-04-17-00-05-02-v3-1-6.zip]', '2025-04-17 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-17 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 13:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 13:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 13:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (255999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256078, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-17 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256190, 'Database Backup [database_backup_2025-04-18-00-03-10-v3-1-6.zip]', '2025-04-18 00:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (256999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-18 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257019, 'Database Backup [database_backup_2025-04-19-00-02-09-v3-1-6.zip]', '2025-04-19 00:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257692, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-19 21:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257693, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-19 21:05:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:05:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:05:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:05:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-19 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-19 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-19 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257790, 'Database Backup [database_backup_2025-04-20-00-03-03-v3-1-6.zip]', '2025-04-20 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (257999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258472, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-20 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258578, 'Database Backup [database_backup_2025-04-21-00-00-07-v3-1-6.zip]', '2025-04-21 00:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259020, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:94e1:ea74:f84a:64cd]', '2025-04-21 12:53:09', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259021, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:94e1:ea74:f84a:64cd]', '2025-04-21 12:53:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:50:03', '[CRON]');
INSERT INTO `tbl