#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=195111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170823, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.37]', '2025-01-02 13:45:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170827, 'New Payment Mode Added [ID: 5, Name:Cheque]', '2025-01-02 13:50:46', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170828, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:52:57', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170832, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:54:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170833, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:56:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170834, 'Payment Mode Updated [ID: 5, Name:Cheque]', '2025-01-02 13:56:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170838, 'Payment Recorded [ID:123, Invoice Number: INV-133/05/2024, Total: $10,000.00]', '2025-01-02 14:00:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (170999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-02 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-02 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-02 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171166, 'Database Backup [database_backup_2025-01-03-00-02-02-v3-1-6.zip]', '2025-01-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171524, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.69]', '2025-01-03 11:06:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-03 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-03 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-03 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171954, 'Database Backup [database_backup_2025-01-04-00-03-02-v3-1-6.zip]', '2025-01-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (171999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172642, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-04 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172643, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172743, 'Database Backup [database_backup_2025-01-05-00-04-02-v3-1-6.zip]', '2025-01-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (172999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-05 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-05 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-05 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173524, 'Database Backup [database_backup_2025-01-06-00-00-03-v3-1-6.zip]', '2025-01-06 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174326, 'Database Backup [database_backup_2025-01-07-00-05-02-v3-1-6.zip]', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:46:02',