#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=383522 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371326, 'Database Backup [database_backup_2025-09-25-00-04-04-v3-3-1.zip]', '2025-09-25 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371975, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371976, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371977, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-25 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371978, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371979, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371980, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371981, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-25 21:03:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371982, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371983, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372080, 'Database Backup [database_backup_2025-09-26-00-03-02-v3-3-1.zip]', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372177, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:10:40', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372178, 'Failed Login Attempt [Email: tishara.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:10:52', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372179, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:11:07', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372180, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:11:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372184, 'Database Backup [database_backup_2025-09-29-06-52-03-v3-3-1.zip]', '2025-09-29 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:03:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:03:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:03:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-30 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-30 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-30 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373460, 'Database Backup [database_backup_2025-10-01-00-00-02-v3-3-1.zip]', '2025-10-01 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (373999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-01 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-01 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-01 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374205, 'Database Backup [database_backup_2025-10-02-00-04-02-v3-3-1.zip]', '2025-10-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:02:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:02:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:02:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-02 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-02 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-02 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374950, 'Database Backup [database_backup_2025-10-03-00-04-02-v3-3-1.zip]', '2025-10-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (374999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-03 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-03 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-03 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375053, 'Database Backup [database_backup_2025-10-06-06-59-03-v3-3-1.zip]', '2025-10-06 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (375146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.',