#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=377067 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362014, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8f6:a4c3:2df2:c352:90e9]', '2025-09-09 11:03:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362015, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8f6:a4c3:2df2:c352:90e9]', '2025-09-09 11:03:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362421, 'Database Backup [database_backup_2025-09-10-00-00-02-v3-3-1.zip]', '2025-09-10 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362989, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8f6:5440:64a8:7680:843]', '2025-09-10 18:24:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362999, 'Invoice Status Updated [Invoice Number: INV-186/08/2025, From: Overdue To: Paid]', '2025-09-10 18:38:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363000, 'Payment Recorded [ID:138, Invoice Number: INV-186/08/2025, Total: $500.00]', '2025-09-10 18:38:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363001, 'Copied Invoice INV-186/08/2025', '2025-09-10 18:39:10', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363002, 'Invoice Status Updated [Invoice Number: INV-189/09/2025, From: Draft To: Unpaid]', '2025-09-10 18:39:45', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363057, 'Non Existing User Tried to Login [Email: admin@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8f6:31be:4bbd:4a1d:1579]', '2025-09-10 20:22:11', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363058, 'Non Existing User Tried to Login [Email: admin@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8f6:31be:4bbd:4a1d:1579]', '2025-09-10 20:22:21', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363059, 'Non Existing User Tried to Login [Email: admin@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8f6:31be:4bbd:4a1d:1579]', '2025-09-10 20:22:39', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363078, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363079, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363080, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363081, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363082, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363179, 'Database Backup [database_backup_2025-09-11-00-03-01-v3-3-1.zip]', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363930, 'Database Backup [database_backup_2025-09-12-00-05-02-v3-3-1.zip]', '2025-09-12 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:00:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364570, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Send Invoice to Customer]', '2025-09-12 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364571, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Send Invoice to Customer]', '2025-09-12 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364572, 'Email sent to: tishara.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-09-12 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364573, 'Email sent to: clientportal@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-09-12 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364574, 'Email sent to: dallas.f@saylessdigital.io Subject: Recurring Invoices Cron Job Activity', '2025-09-12 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364575, 'Email sent to: tishara.f@saylesstt.com Subject: Recurring Expenses Cron Job Activity', '2025-09-12 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364576, 'Email sent to: clientportal@saylesstt.com Subject: Recurring Expenses Cron Job Activity', '2025-09-12 21:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364577, 'Email sent to: dallas.f@saylessdigital.io Subject: Recurring Expenses Cron Job Activity', '2025-09-12 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364674, 'Database Backup [database_backup_2025-09-13-00-04-02-v3-3-1.zip]', '2025-09-13 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365323, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-13 21:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365324, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-13 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365325, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-13 21:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365326, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-13 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365327, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-13 21:04:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365328, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-09-13 21:04:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365329, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Send Invoice to Customer]', '2025-09-13 21:04:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365330, 'Email Sent To [Email: support@saylesstt.com, Template: Send Invoice to Customer]', '2025-09-13 21:04:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365331, 'Email sent to: tishara.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-09-13 21:04:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365332, 'Email sent to: clientportal@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-09-13 21:04:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365333, 'Email sent to: dallas.f@saylessdigital.io Subject: Recurring Invoices Cron Job Activity', '2025-09-13 21:04:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:04:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:04:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:04:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-13 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-13 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-13 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365430, 'Database Backup [database_backup_2025-09-14-00-04-01-v3-3-1.zip]', '2025-09-14 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (365999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366073, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Due Notice]', '2025-09-14 21:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366074, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Due Notice]', '2025-09-14 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-14 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-14 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-14 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366174, 'Database Backup [database_backup_2025-09-15-00-04-03-v3-3-1.zip]', '2025-09-15 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-15 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-15 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (366242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-15 02:20:02', '[CRON]');