#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=113220 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90061, 'Database Backup [database_backup_2024-09-23-00-04-02-v3-1-6.zip]', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90869, 'Database Backup [database_backup_2024-09-24-00-03-03-v3-1-6.zip]', '2024-09-24 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91578, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-24 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91690, 'Database Backup [database_backup_2024-09-25-00-04-02-v3-1-6.zip]', '2024-09-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (91999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92297, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-09-25 17:22:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92514, 'Database Backup [database_backup_2024-09-26-00-00-04-v3-1-6.zip]', '2024-09-26 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (92999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93088, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-09-26 17:05:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93329, 'Database Backup [database_backup_2024-09-27-00-05-03-v3-1-6.zip]', '2024-09-27 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93717, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-09-27 12:02:30', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-27 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (93842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-27 15:47:01', '[CRON]');
INSERT INTO `tbla