#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=78668 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55293, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-09 17:31:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55297, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Send Invoice to Customer]', '2024-08-09 17:36:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55298, 'Email Sent To [Email: support@saylesstt.com, Template: Send Invoice to Customer]', '2024-08-09 17:36:10', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55494, 'Database Backup [database_backup_2024-08-10-00-02-02-v3-1-6.zip]', '2024-08-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55831, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-10 11:18:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55832, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-10 11:18:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56040, 'Invoice Status Updated [Invoice Number: INV-161/08/2024, From: Unpaid To: Paid]', '2024-08-10 18:09:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56041, 'Payment Recorded [ID:110, Invoice Number: INV-161/08/2024, Total: $210.00]', '2024-08-10 18:09:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56042, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-10 18:09:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56043, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-10 18:09:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56128, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56222, 'Database Backup [database_backup_2024-08-11-00-02-02-v3-1-6.zip]', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56943, 'Database Backup [database_backup_2024-08-12-00-00-04-v3-1-6.zip]', '2024-08-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57478, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 181.118.49.236]', '2024-08-12 17:49:04', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57668, 'Database Backup [database_backup_2024-08-13-00-02-05-v3-1-6.zip]', '2024-08-13 00:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58203, 'Email Sent To [Email: claireclottey@gmail.com, Template: Forgot Password]', '2024-08-13 17:47:26', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58204, 'Password Reset Email sent [Email: claireclottey@gmail.com, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 17:47:26', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58205, 'Failed Login Attempt [Email: claireclottey@gmail.com, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 17:49:54', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58206, 'User Successfully Logged In [User Id: 88, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 17:50:37', 'Claire Clottey');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58237, 'Failed Login Attempt [Email: claireclottey@gmail.com, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 18:49:48', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58304, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58398, 'Database Backup [database_backup_2024-08-14-00-02-03-v3-1-6.zip]', '2024-08-14 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58471, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-14 02:30:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59135, 'Database Backup [database_backup_2024-08-15-00-00-05-v3-1-6.zip]', '2024-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:12:02', '[CRON]');
INSERT INT