#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=92514 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67868, 'Database Backup [database_backup_2024-08-27-00-04-02-v3-1-6.zip]', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68430, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.154]', '2024-08-27 16:57:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68437, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 622]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68438, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 621]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68439, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 620]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68440, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 619]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68441, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 618]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68442, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 617]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68443, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 616]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68444, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 615]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68445, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 614]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68446, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 613]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68447, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 612]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68448, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 611]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68449, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 610]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68450, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 609]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68451, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 608]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68452, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 607]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68453, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 606]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68454, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 605]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68455, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 604]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68456, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 603]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68457, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 602]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68458, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 601]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68459, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 600]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68460, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 599]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68461, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 598]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68462, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 597]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68463, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 596]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68464, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 595]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68465, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 594]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68466, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 593]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68467, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 592]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68468, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 591]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68469, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 590]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68470, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 589]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68471, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 588]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68472, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 587]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68473, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 586]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68474, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 585]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68475, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 584]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68476, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 583]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68477, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 582]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68478, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 581]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68479, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 580]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68480, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 579]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68481, 'Proposal Deleted [ProposalID:7]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68482, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 578]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68483, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 577]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68484, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 576]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68485, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 575]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68486, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 574]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68487, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 573]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68488, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 572]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68489, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 571]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68490, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 570]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68491, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 569]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68492, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 568]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68493, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 567]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68494, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 566]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68495, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 565]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68496, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 564]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68497, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 563]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68498, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 562]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68499, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 561]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68500, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 560]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68501, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 559]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68502, 'Lead Attachment Deleted [ID: 559]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68503, 'Proposal Deleted [ProposalID:6]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68504, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 558]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68505, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 557]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68506, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 556]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68507, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 555]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68508, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 554]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68509, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 553]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68510, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 552]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68511, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 551]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68512, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 550]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68513, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 549]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68514, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 548]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68515, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 547]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68516, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 546]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68517, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 545]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68518, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 544]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68519, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 543]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68520, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 542]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68521, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 541]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68522, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 540]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68523, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 539]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68524, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 538]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68525, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 537]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68526, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 536]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68527, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 535]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68528, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 534]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68529, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 532]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68530, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 531]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68531, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 530]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68532, 'Proposal Deleted [ProposalID:3]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68533, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 529]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68534, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 528]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68535, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 527]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68536, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 526]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68537, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 525]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68538, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 524]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68539, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 523]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68540, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 522]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68541, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 521]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68542, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 520]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68543, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 519]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68544, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 518]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68545, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 517]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68546, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 516]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68547, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 515]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68548, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 514]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68549, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 513]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68550, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 512]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68551, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 511]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68552, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 510]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68553, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 509]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68554, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 508]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68555, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 507]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68556, 'Proposal Deleted [ProposalID:2]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68557, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 506]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68558, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 505]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68559, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 504]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68560, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 503]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68561, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 500]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68562, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 498]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68563, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 497]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68564, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 496]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68565, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 495]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68566, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 494]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68567, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 493]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68568, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 492]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68569, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 490]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68570, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 489]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68571, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 488]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68572, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 487]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68573, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 486]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68574, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 485]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68575, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 484]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68576, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 483]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68577, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 482]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68578, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 481]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68579, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 480]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68580, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 479]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68581, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 476]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68582, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 475]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68583, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 474]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68584, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 473]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68585, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 472]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68586, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 471]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68587, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 470]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68588, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 469]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68589, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 468]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68590, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 467]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68591, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 466]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68592, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 465]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68593, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 464]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68594, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 463]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68595, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 462]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68596, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 461]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68597, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 460]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68598, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 459]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68599, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 458]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68600, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 457]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68601, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 456]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68602, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 455]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68603, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 454]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68604, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 453]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68605, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 452]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68606, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 76]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68607, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 41]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68608, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 26]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68609, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 25]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68610, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 24]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68839, 'Database Backup [database_backup_2024-08-28-00-03-03-v3-1-6.zip]', '2024-08-28 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69524, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69624, 'Database Backup [database_backup_2024-08-29-00-00-03-v3-1-6.zip]', '2024-08-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-29 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-29 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-29 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70441, 'Database Backup [database_backup_2024-08-30-00-00-04-v3-1-6.zip]', '2024-08-30 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 14:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 14:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 14:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70994, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.154]', '2024-08-30 16:08:33', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70998, 'Payment Recorded [ID:112, Invoice Number: INV-125/04/2024, Total: $2,520.00]', '2024-08-30 16:19:49', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (70999, 'Email Sent To [Email: keripatrick@me.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-30 16:19:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71000, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-08-30 16:19:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71004, 'Payment Recorded [ID:113, Invoice Number: INV-133/05/2024, Total: $5,295.00]', '2024-08-30 16:24:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71005, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-30 16:24:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71006, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-08-30 16:24:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71277, 'Database Backup [database_backup_2024-08-31-00-03-01-v3-1-6.zip]', '2024-08-31 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71329, 'New Expense Category Added [ID: 6]', '2024-08-31 01:26:28', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71333, 'New Expense Added [11]', '2024-08-31 01:32:22', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71337, 'Expense Updated [11]', '2024-08-31 01:39:44', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71344, 'New Expense Added [12]', '2024-08-31 01:51:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71345, 'New Expense Added [13]', '2024-08-31 01:53:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71382, 'New Expense Category Added [ID: 7]', '2024-08-31 03:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71383, 'New Expense Added [14]', '2024-08-31 03:02:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-31 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (71696, 'Failed to connect to IMAP auto importing tickets for department billing