#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=147342 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124353, 'Database Backup [database_backup_2024-11-05-00-00-04-v3-1-6.zip]', '2024-11-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124624, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.208]', '2024-11-05 08:14:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125048, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-05 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125049, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-05 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125152, 'Database Backup [database_backup_2024-11-06-00-05-02-v3-1-6.zip]', '2024-11-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 06:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 07:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 07:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 07:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-06 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-06 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-06 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125945, 'Database Backup [database_backup_2024-11-07-00-04-03-v3-1-6.zip]', '2024-11-07 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (125999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126264, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.208]', '2024-11-07 09:48:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126268, 'Invoice Status Updated [Invoice Number: INV-165/11/2024, From: Unpaid To: Paid]', '2024-11-07 09:53:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126269, 'Payment Recorded [ID:119, Invoice Number: INV-165/11/2024, Total: $420.00]', '2024-11-07 09:53:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126270, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-11-07 09:53:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126274, 'Payment Recorded [ID:120, Invoice Number: INV-125/04/2024, Total: $5,040.00]', '2024-11-07 10:00:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126275, 'Email Sent To [Email: keripatrick@me.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-11-07 10:00:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126693, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.208]', '2024-11-07 22:26:16', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126748, 'Database Backup [database_backup_2024-11-08-00-03-03-v3-1-6.zip]', '2024-11-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (126999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127436, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-08 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127437, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-08 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-08 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-08 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-08 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127540, 'Database Backup [database_backup_2024-11-09-00-02-01-v3-1-6.zip]', '2024-11-09 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (127999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-09 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-09 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-09 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11