#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=374205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357200, 'Database Backup [database_backup_2025-09-03-00-02-02-v3-3-1.zip]', '2025-09-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357954, 'Database Backup [database_backup_2025-09-04-00-04-03-v3-3-1.zip]', '2025-09-04 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358606, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358607, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358608, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358609, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358610, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-04 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358611, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358612, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358613, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-04 21:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358710, 'Database Backup [database_backup_2025-09-05-00-02-02-v3-3-1.zip]', '2025-09-05 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359455, 'Database Backup [database_backup_2025-09-06-00-03-02-v3-3-1.zip]', '2025-09-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:59:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:59:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:59:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360200, 'Database Backup [database_backup_2025-09-07-00-00-04-v3-3-1.zip]', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360849, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360850, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360851, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360852, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360853, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-07 21:04:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360854, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360855, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360856, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360950, 'Database Backup [database_backup_2025-09-08-00-01-03-v3-3-1.zip]', '2025-09-08 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361015, 'Failed to connect to IMA